
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1173.C - Message 1173 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1170 messages.
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1173 message from the ZMsgBuf.
//
void Dec1173(tMSGBUF *ZMsgBuf, tMSG1173 *Msg)
{                                            
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1173 message in the ZMsgBuf. 
//
void Bld1173(tMSGBUF *ZMsgBuf, tMSG1173 *Msg)
{

}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1173 message from the ZMsgBuf.
//
void Show1173(tMSG1173 *Msg)
{
   char    Buf[80] = "";
   char    DRValidity[3];
   char    BackupStatus[2];        
   
   static tSHORT current_i=0;
   tSHORT i;
   
   // output the data items   
   sprintf(Buf,"%05d",Msg->SeqNo);ShowText(Buf,TIMR+ 6,TIMC+ 4);

   i = current_i;

   if (current_i == 9)
     current_i = 0;
   else
     current_i++;

//   for (i = 0; i < 10; i++) {
     // Gyro validity flags  
     strcpy(DRValidity, "  ");
     if(Msg->DrMeas[i].DRMeasValid & 1) DRValidity[0] = 'R';// HR validity
     if(Msg->DrMeas[i].DRMeasValid & 2) DRValidity[1] = 'T';// Gyro Temp. Validity
     sprintf(Buf,"%3s", DRValidity); ShowText(Buf, DRFR, DRFC + 4);

     // backup flags
     strcpy(BackupStatus, " ");
     if(Msg->DrMeas[i].DRMeasValid & 4) BackupStatus[0] = 'B';
     sprintf(Buf,"%2s", BackupStatus);ShowText(Buf, DRFR, DRFC + 7);

     // output Gyro data items   
     sprintf(Buf,"%05.02f",(float)Msg->DrMeas[i].HeadingRate/100.0);ShowText(Buf,DRFR+ 1,DRFC+ 5);
     sprintf(Buf,"%05.02f",(float)Msg->DrMeas[i].GyroTemp/100.0 );ShowText(Buf,DRFR+ 2,DRFC+ 5);

     // output Speed data items   
     sprintf(Buf,"%06.02f",(float)Msg->DrMeas[i].Speed/100.0);ShowText(Buf,DRSR,DRSC+ 5);
     sprintf(Buf,"%06.02f",(float)Msg->DrMeas[i].MeasTime/100.0);ShowText(Buf,DRSR+ 1,DRSC+ 5);
//   }        



}                                                   
                                      
                                           
